/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OvereatingModifier
extends Modifier {
    private static final ResourceLocation IS_EATING = new ResourceLocation("materialis", "eating_overslime");
    public static int overslimeAmount = 20;

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        overslime.setFriend(volatileData);
    }

    public InteractionResult onToolUse(IToolStackView tool, int level, Level world, Player player, InteractionHand hand, EquipmentSlot slot) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        if (!tool.isBroken() && overslime.getOverslime(tool) >= overslimeAmount * level && player.m_36391_(true)) {
            player.m_6672_(hand);
            tool.getPersistentData().putBoolean(IS_EATING, true);
            return InteractionResult.CONSUME;
        }
        tool.getPersistentData().remove(IS_EATING);
        return InteractionResult.PASS;
    }

    public boolean onStoppedUsing(IToolStackView tool, int level, Level world, LivingEntity entity, int timeLeft) {
        tool.getPersistentData().remove(IS_EATING);
        return false;
    }

    public boolean onFinishUsing(IToolStackView tool, int level, Level world, LivingEntity entity) {
        Player player;
        ModDataNBT persistentData = tool.getPersistentData();
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        boolean wasEating = persistentData.getBoolean(IS_EATING);
        persistentData.remove(IS_EATING);
        if (!tool.isBroken() && overslime.getOverslime(tool) >= overslimeAmount * level && wasEating && entity instanceof Player && (player = (Player)entity).m_36391_(false)) {
            player.m_36324_().m_38707_(level, (float)level * 0.1f);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.nextFloat() * 0.1f + 0.9f);
            overslime.onDamageTool(tool, 1, overslimeAmount * level, entity);
            return true;
        }
        return false;
    }

    public UseAnim getUseAction(IToolStackView tool, int level) {
        return tool.getPersistentData().getBoolean(IS_EATING) ? UseAnim.EAT : UseAnim.NONE;
    }

    public int getUseDuration(IToolStackView tool, int level) {
        return tool.getPersistentData().getBoolean(IS_EATING) ? 32 : 0;
    }
}

